/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.momlove;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import committee.nova.momlove.command.AddKeyCmd;
import committee.nova.momlove.command.DelKeyCmd;
import committee.nova.momlove.command.SetLoveCMd;
import committee.nova.momlove.command.UnLoveCMd;
import committee.nova.momlove.config.Configuration;
import committee.nova.momlove.handler.ConfigHandler;
import committee.nova.momlove.utils.FileUtils;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

@Mod(value="momlove")
public class MomLove {
    public static final String MODID = "momlove";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Path configFolder;
    private static Configuration config;

    public MomLove() {
        configFolder = FMLPaths.CONFIGDIR.get().resolve(MODID);
        FileUtils.checkFolder(configFolder);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (n, s) -> true));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Path getConfigFolder() {
        return configFolder;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void setConfig(Configuration config) {
        MomLove.config = config;
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent e) {
        config = ConfigHandler.load();
    }

    public static boolean setLove(Player player, boolean byKey) {
        boolean b = config.getUuidData().add(player.m_20148_());
        ConfigHandler.onChange();
        if (b) {
            LOGGER.info("Set love for player {}", (Object)player.m_7755_().getString());
        }
        if (b) {
            player.m_5661_((Component)Component.m_237110_((String)(byKey ? "momlove.keys.success" : "momlove.love.success"), (Object[])new Object[]{Component.m_237115_((String)"momlove.appellation.you.lower").getString()}), true);
        }
        return b;
    }

    public static boolean unLove(Player player) {
        boolean b = MomLove.getConfig().getUuidData().remove(player.m_20148_());
        ConfigHandler.onChange();
        if (b) {
            LOGGER.info("Unlove player {}", (Object)player.m_7755_().getString());
        }
        if (b) {
            player.m_5661_((Component)Component.m_237110_((String)"momlove.unlove.success", (Object[])new Object[]{Component.m_237115_((String)"momlove.appellation.you.upper").getString()}), true);
        }
        return b;
    }

    public static boolean addKey(String keyWord) {
        boolean b = MomLove.getConfig().getKeyWordsData().add(keyWord);
        ConfigHandler.onChange();
        if (b) {
            LOGGER.info("Add keyword {}", (Object)keyWord);
        }
        return b;
    }

    public static boolean delKey(String keyWord) {
        boolean b = MomLove.getConfig().getKeyWordsData().remove(keyWord);
        ConfigHandler.onChange();
        if (b) {
            LOGGER.info("Remove keyword {}", (Object)keyWord);
        }
        return b;
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent.Submitted e) {
        String msg = e.getRawText();
        if (MomLove.getConfig().getKeyWordsData().stream().noneMatch(msg::startsWith)) {
            return;
        }
        ServerPlayer player = e.getPlayer();
        MomLove.setLove((Player)player, true);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mom").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"love").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> SetLoveCMd.execute((CommandContext<CommandSourceStack>)commandContext, EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets")))))).then(Commands.m_82127_((String)"unlove").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> UnLoveCMd.execute((CommandContext<CommandSourceStack>)commandContext, EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"keys").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"keyword", (ArgumentType)StringArgumentType.greedyString()).executes(commandContext -> AddKeyCmd.execute((CommandContext<CommandSourceStack>)commandContext, StringArgumentType.getString((CommandContext)commandContext, (String)"keyword")))))).then(Commands.m_82127_((String)"del").then(Commands.m_82129_((String)"keyword", (ArgumentType)StringArgumentType.greedyString()).executes(commandContext -> DelKeyCmd.execute((CommandContext<CommandSourceStack>)commandContext, StringArgumentType.getString((CommandContext)commandContext, (String)"keyword")))))));
    }
}

